;writes 256 bytes from hl to vdp
/*
writeVDP256:
    ld b,0
1:
    ld a,(hl) : out ($98),a : inc l    
    djnz 1b
    ret
*/

clearSprites:
	ld hl,spritesTable : ld de,spritesTable+1 : ld bc,4*4-1 : ld (hl),0 : ldir
	call doSprites
	ret

;tmp set sprites to screen
doSprites:
	;4 sprites
	ld hl,spritesTable : ld de,$1b00 : ld bc,4*4 : call LDIRVM
	ret
fillTiles01:
	ld hl,tilesColors : ld de,8192 : ld bc, 35*8 : call LDIRVM
	ld hl,tilesColors : ld de,8192+2048 : ld bc, 35*8 : call LDIRVM
	ld hl,tilesColors : ld de,8192+4096 : ld bc, 35*8 : call LDIRVM
	ret
fillTiles02:
	ld hl,tilesColors2 : ld de,8192 : ld bc, 35*8 : call LDIRVM
	ld hl,tilesColors2 : ld de,8192+2048 : ld bc, 35*8 : call LDIRVM
	ld hl,tilesColors2 : ld de,8192+4096 : ld bc, 35*8 : call LDIRVM
	ret
fillTiles03:
	ld hl,tilesColors3 : ld de,8192 : ld bc, 35*8 : call LDIRVM
	ld hl,tilesColors3 : ld de,8192+2048 : ld bc, 35*8 : call LDIRVM
	ld hl,tilesColors3 : ld de,8192+4096 : ld bc, 35*8 : call LDIRVM
	ret

fillFontMenu:
	;ld hl,font : ld de,2048-768 : ld bc, 768 : call LDIRVM
	ld hl,font : ld de,4096-768 : ld bc, 768 : call LDIRVM
	ld hl,font : ld de,6144-768 : ld bc, 768 : call LDIRVM
	;font colors - lazy 768 table - OMG
	;ld hl,fontColors : ld de,8192+2048 - 768 : ld bc, 768 : call LDIRVM
	ld hl,fontColors : ld de,8192+4096 - 768 : ld bc, 768 : call LDIRVM
	ld hl,fontColors : ld de,8192+6144 - 768 : ld bc, 768 : call LDIRVM

	ret

fillFont:
	ld hl,font : ld de,2048-768 : ld bc, 768 : call LDIRVM
	ld hl,font : ld de,4096-768 : ld bc, 768 : call LDIRVM
	ld hl,font : ld de,6144-768 : ld bc, 768 : call LDIRVM
	;font colors - lazy 768 table - OMG
	ld hl,fontColors : ld de,8192+2048 - 768 : ld bc, 768 : call LDIRVM
	ld hl,fontColors : ld de,8192+4096 - 768 : ld bc, 768 : call LDIRVM
	ld hl,fontColors : ld de,8192+6144 - 768 : ld bc, 768 : call LDIRVM

	ret

fillVDP:
	call fillFont	
    ;(?)need to switch for more conomy mode without thirds
    ;patterns
	ld hl,tilesPixles : ld de,0000 : ld bc, 35*8 : call LDIRVM

	ld hl,tilesPixles : ld de,2048 : ld bc, 35*8 : call LDIRVM	

	ld hl,tilesPixles : ld de,4096 : ld bc, 35*8 : call LDIRVM	

;    ld de,0000 : call setVADDR : ld hl,tilesPixles : call writeVDP256
;    ld de,2048 : call setVADDR : ld hl,tilesPixles : call writeVDP256
;    ld de,4096 : call setVADDR : ld hl,tilesPixles : call writeVDP256

    ;colors
	ld hl,tilesColors : ld de,8192 : ld bc, 35*8 : call LDIRVM	

	ld hl,tilesColors : ld de,8192+2048 : ld bc, 35*8 : call LDIRVM	

	ld hl,tilesColors : ld de,8192+4096 : ld bc, 35*8 : call LDIRVM	

;    ld de,$2000 : call setVADDR : ld hl,tilesColors : call writeVDP256
;    ld de,8192+2048 : call setVADDR : ld hl,tilesColors : call writeVDP256
;    ld de,8192+4096 : call setVADDR : ld hl,tilesColors : call writeVDP256
	ld hl,spritesPixels : ld de,$3800 : ld bc,1536: call LDIRVM
    ret

;fills name table with specific tile
; A - tile
fillTile:    
    push af   
    ld a,e     
    ld l,d : ld h,0 
    add hl,hl : add hl,hl : add hl,hl : add hl,hl : add hl,hl
    ld d,0 : add hl,de
    ld de,$1800 
    add hl,de ;: ex de,hl
    ;call setVADDRHL
	pop af    
	call WRTVRM ;to hl writes a
    ;out ($98),a    
    ret

;de - real coords
; a - tile to fill
fillTileXY:    
    push af   
	
	ld a,e : add 4
	rra : rra : rra ;/8
	and 31
	ld e,a	

	;get y
	ld a,d : add 6
	rra : rra : rra ;/8
	and 31
	ld d,a

	;
    ld a,e     
    ld l,d : ld h,0 
    add hl,hl : add hl,hl : add hl,hl : add hl,hl : add hl,hl
    ld d,0 : add hl,de
    ld de,$1800 
    add hl,de ;: ex de,hl
    ;call setVADDRHL
	pop af    
	call WRTVRM ;to hl writes a
    ;out ($98),a    
    ret
;fill all screen with one tile
clearScreen:
	ld hl,$1800 : ld bc,768 : ld a,0 : call FILVRM
/*    
    xor a
    ld de,$1800 : call setVADDR
    ld b,0
1:
    out ($98),a
    djnz 1b

    ld b,0
1:
    out ($98),a
    djnz 1b

    ld b,0
1:
    out ($98),a
    djnz 1b
*/
    ret

;set addr for write!
;de - addr for vdp
/*
setVADDR:  
    di
    ld    A,E    
    out   ($99),A
    ld    A,D        
    and 00111111b
    or  01000000b
    out   ($99),A
    ei

    ret

setVADDRHL:  
    di
    ld    A,l
    out   ($99),A
    ld    A,h        
    and 00111111b
    or  01000000b
    out   ($99),A
    ei
    ret
*/

;The two bytes are formatted as follows:
;
;		        7	6	5	4	3	2	1	0
;Byte #0		A7	A6	A5	A4	A3	A2	A1	A0
;Byte #1		0	R/W	A13	A12	A11	A10	A9	A8
;A13-A0 make up the address. R/W specifies whether you want to read or write
;from that address. It should be 0 for reading, 1 for writing.


animateFire:
	;animate delay
	ld a,(fireDelay) : inc a : and 3 : ld (fireDelay),a
	or a: ret nz
 	;process frames
	ld a,(fireFrame)
	inc a : and 3 : ld (fireFrame),a
	ld hl,fireTile: add a,a : add a,a : add a,a : ld c,a : ld b,0
	add hl,bc
	;write hl to vram at fire tile position
	push hl : 	ld de,3*8 : ld bc,8 : call LDIRVM : pop hl	
	push hl : 	ld de,3*8+2048 : ld bc,8 : call LDIRVM : pop hl	
	ld de,3*8+4096 : ld bc,8 : call LDIRVM 
;	push hl : 	ld de,3*8 : call setVADDR :	call writeVDP8 : pop hl
;	push hl : 	ld de,3*8+2048 : call setVADDR : call writeVDP8 : pop hl
;	ld de,3*8+4096 : call setVADDR : call writeVDP8

	ret

animateGold:
	;animate delay
	ld a,(goldDelay) : inc a : and 3 : ld (goldDelay),a
	or a: ret nz
 	;process frames
	ld a,(fireFrame);one frmae count
	ld hl,goldTile: add a,a : add a,a : add a,a : ld c,a : ld b,0
	add hl,bc
	;write hl to vram at fire tile position
	push hl : 	ld de,1*8 : ld bc,8 : call LDIRVM : pop hl	
	push hl : 	ld de,1*8+2048 : ld bc,8 : call LDIRVM : pop hl	
	ld de,1*8+4096 : ld bc,8 : call LDIRVM 


	ret
/*
writeVDP8:
	ld b,8
1:
	ld a,(hl): out ($98),a : inc hl
	djnz 1b
	ret
*/
goldTile:
	DB 0, 0, 0, 0, 0, 126, 126, 126
	DB 0, 0, 0, 0, 126, 126, 126,0
	DB 0, 0, 0, 0, 0,126, 126, 126
	DB 0, 0, 0, 0, 0, 0, 01111110b, 11111111b

fireTile:
	DEFB	  2,  0, 32,  1,122, 63,118,165	
	DEFB	 64,  0,  0, 10, 50, 59,165,181	
	DEFB	  8,  0,  0, 76, 34,183,213,186	
	DEFB	  0,  2,  0,  2, 50, 55, 53,237	

spritesPixels:
	include "gfx\heroIdle.asm"
	include "gfx\heroLadder.asm"
	include "gfx\heroFall.asm"
	include "gfx\heroLeft.asm"
	include "gfx\heroRight.asm"

	include "gfx\enemyIdle.asm"
	include "gfx\enemyLadder.asm"
	include "gfx\enemyFall.asm"
	include "gfx\enemyLeft.asm"
	include "gfx\enemyRight.asm"
endSprites:

	display /d,"sprites: ",endSprites-spritesPixels

;32x8
tilesPixles:
	DB 0, 0, 0, 0, 0, 0, 0, 0
	DB 0, 0, 0, 0, 0, 126, 126, 126
	DB 66, 255, 0, 66, 66, 255, 0, 66
	DB 0, 0, 16, 2, 116, 62, 118, 165
	DB 8, 20, 56, 96, 168, 68, 2, 0
	DB 0, 6, 14, 30, 30, 30, 30, 0
	DB 0, 192, 224, 240, 240, 240, 240, 0
	DB 30, 30, 30, 30, 30, 30, 30, 0
	DB 240, 240, 240, 240, 240, 240, 240, 0
	DB 0, 0, 0, 8, 28, 62, 0, 62
	DB 0, 24, 24, 0, 126, 60, 24, 0
	DB 0, 24, 24, 0, 126, 60, 24, 0
	DB 0, 0, 0, 0, 0, 0, 0, 0
	DB 0, 0, 0, 0, 0, 0, 0, 0
	DB 0, 0, 0, 44, 0, 52, 0, 0
	DB 0, 0, 94, 94, 0, 122, 122, 0
	DB 0, 223, 223, 223, 0, 253, 253, 253
	DB 0, 239, 70, 239, 0, 70, 128, 0
	DB 0, 255, 102, 255, 0, 255, 0, 0
	DB 0, 247, 98, 247, 0, 98, 1, 0
	DB 0, 253, 249, 114, 52, 0, 0, 0
	DB 60, 0, 126, 251, 0, 85, 253, 253
	DB 0, 16, 48, 118, 118, 48, 16, 0
	DB 0, 8, 12, 110, 110, 12, 8, 0
	DB 0, 223, 223, 223, 0, 253, 253, 253
	DB 0, 60, 60, 60, 0, 60, 0, 0
	DB 0, 16, 48, 118, 118, 48, 16, 0
	DB 0, 8, 12, 110, 110, 12, 8, 0
	DB 60, 0, 126, 251, 0, 85, 253, 253
	DB 0, 253, 249, 114, 52, 0, 36, 126
	DB 0, 0, 0, 0, 0, 0, 0, 0
	DB 0, 0, 0, 0, 0, 0, 0, 0
	DB 255, 255, 255, 255, 255, 255, 255, 255
	DB 255, 255, 255, 255, 255, 255, 255, 255
	DB 255, 255, 255, 255, 255, 255, 255, 255
	
tilesColors:
	DB 16, 16, 16, 16, 16, 0, 16, 16
	DB 176, 176, 176, 176, 176, 240, 176, 176
	DB 176, 160, 160, 176, 176, 160, 160, 176
	DB 128, 128, 128, 128, 128, 128, 139, 139
	DB 240, 240, 112, 112, 240, 240, 112, 240
	DB 64, 64, 64, 64, 64, 64, 64, 64
	DB 64, 64, 64, 64, 64, 64, 64, 64
	DB 64, 64, 64, 64, 64, 64, 64, 64
	DB 64, 64, 64, 64, 64, 64, 64, 64
	DB 128, 128, 128, 128, 128, 128, 128, 176
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 128, 208, 208, 128, 128, 208, 128, 128
	DB 128, 208, 208, 128, 128, 208, 128, 128
	DB 128, 208, 128, 128, 128, 208, 128, 128
	DB 16, 48, 48, 32, 16, 80, 80, 16
	DB 16, 48, 48, 32, 16, 80, 16, 16
	DB 16, 48, 48, 32, 16, 80, 80, 16
	DB 16, 176, 112, 112, 64, 16, 16, 16
	DB 128, 176, 112, 112, 0, 212, 132, 132
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 128, 208, 128, 128, 128, 208, 128, 128
	DB 16, 48, 48, 32, 16, 80, 16, 16
	DB 245, 245, 245, 245, 245, 245, 245, 245
	DB 245, 245, 245, 245, 245, 245, 245, 245
	DB 176, 176, 160, 112, 0, 212, 132, 132
	DB 16, 176, 112, 112, 64, 16, 32, 192
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 240, 240, 240, 240, 240, 240, 240, 240
	DB 176, 176, 176, 176, 176, 176, 176, 176
	DB 128, 128, 128, 128, 128, 128, 128, 128

tilesColors2:
	DB 16, 16, 16, 16, 16, 0, 16, 16
	DB 176, 176, 176, 176, 176, 240, 176, 176
	DB 224, 240, 240, 224, 224, 240, 224, 224
	DB 208, 208, 208, 208, 208, 208, 219, 219
	DB 240, 240, 112, 112, 240, 240, 112, 240
	DB 208, 208, 208, 208, 208, 208, 208, 208
	DB 64, 208, 208, 208, 208, 208, 208, 64
	DB 208, 208, 208, 208, 208, 208, 208, 208
	DB 208, 208, 208, 208, 208, 208, 208, 208
	DB 128, 128, 128, 128, 128, 128, 128, 176
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 128, 208, 208, 192, 128, 112, 128, 128
	DB 128, 208, 192, 112, 128, 192, 112, 128
	DB 192, 192, 112, 112, 112, 192, 112, 112
	DB 16, 176, 208, 208, 16, 96, 128, 16
	DB 16, 176, 208, 208, 16, 96, 16, 16
	DB 16, 176, 208, 208, 16, 96, 96, 16
	DB 16, 176, 112, 112, 64, 16, 16, 16
	DB 128, 176, 112, 112, 0, 36, 116, 116
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 192, 192, 112, 112, 112, 192, 112, 112
	DB 16, 160, 208, 208, 16, 96, 16, 16
	DB 245, 245, 245, 245, 245, 245, 245, 245
	DB 245, 245, 245, 245, 245, 245, 245, 245
	DB 176, 176, 160, 112, 0, 196, 116, 116
	DB 16, 176, 112, 112, 64, 16, 32, 192
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 240, 240, 240, 240, 240, 240, 240, 240
	DB 176, 176, 176, 176, 176, 176, 176, 176
	DB 128, 128, 128, 128, 128, 128, 128, 128
tilesColors3
	DB 16, 16, 16, 16, 16, 0, 16, 16
	DB 176, 176, 176, 176, 176, 240, 176, 176
	DB 224, 240, 240, 224, 224, 240, 224, 224
	DB 96, 96, 96, 96, 96, 96, 107, 107
	DB 240, 240, 112, 112, 240, 240, 112, 240
	DB 208, 96, 96, 96, 96, 96, 96, 208
	DB 64, 96, 96, 96, 96, 96, 96, 64
	DB 96, 96, 96, 96, 96, 96, 96, 208
	DB 96, 96, 96, 96, 96, 96, 96, 208
	DB 128, 128, 128, 128, 128, 128, 128, 176
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 128, 208, 208, 112, 128, 240, 128, 128
	DB 128, 208, 112, 240, 128, 112, 240, 128
	DB 192, 112, 240, 240, 112, 112, 240, 240
	DB 16, 96, 208, 208, 16, 64, 64, 16
	DB 16, 96, 208, 208, 16, 64, 16, 16
	DB 16, 96, 208, 208, 16, 64, 64, 16
	DB 16, 176, 112, 112, 64, 16, 16, 16
	DB 128, 176, 112, 112, 0, 116, 244, 244
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 117, 117, 117, 117, 117, 117, 117, 117
	DB 192, 112, 240, 240, 112, 112, 240, 240
	DB 16, 96, 208, 208, 16, 64, 16, 16
	DB 245, 245, 245, 245, 245, 245, 245, 245
	DB 245, 245, 245, 245, 245, 245, 245, 245
	DB 176, 176, 160, 112, 0, 116, 244, 244
	DB 16, 176, 112, 112, 64, 16, 208, 208
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 16, 16, 16, 16, 16, 16, 16, 16
	DB 240, 240, 240, 240, 240, 240, 240, 240
	DB 176, 176, 176, 176, 176, 176, 176, 176
	DB 128, 128, 128, 128, 128, 128, 128, 128	


font : incbin "gfx\font.fnt"
fontColors:	

		dup 96
		db 15*16,15*16,15*16,15*16,15*16,14*16,4*16,4*16
		edup
